/*
 * RegExpTestGUI.java
 *
 * Created on 19. Dezember 2006, 08:45
 */

package de.mgru.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * A simple application for testing regular expressions. 
 * This little app was inspired by {@link http://java.sun.com/docs/books/tutorial/essential/regex/test_harness.html}.
 * @author mgrunert
 */
public class RegExpTestGUI extends javax.swing.JFrame {
    
    /** Creates new form RegExpTestGUI */
    public RegExpTestGUI() {
        initComponents();
        modeButtonGroup.add(findRadioButton);
        modeButtonGroup.add(matchRadioButton);
        findRadioButton.setSelected(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        modeButtonGroup = new javax.swing.ButtonGroup();
        evalButton = new javax.swing.JButton();
        findRadioButton = new javax.swing.JRadioButton();
        matchRadioButton = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        regExpEditorPane = new javax.swing.JEditorPane();
        jScrollPane3 = new javax.swing.JScrollPane();
        searchTextEditorPane = new javax.swing.JEditorPane();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        resultEditorPane = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        evalButton.setText("evaluate");
        evalButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                evalButtonMouseClicked(evt);
            }
        });

        findRadioButton.setText("find()");
        findRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        findRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));

        matchRadioButton.setText("match()");
        matchRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        matchRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jScrollPane1.setViewportView(regExpEditorPane);

        jScrollPane3.setViewportView(searchTextEditorPane);

        jLabel1.setText("regExp");

        jLabel2.setText("searchText");

        jLabel3.setText("result");

        jScrollPane4.setViewportView(resultEditorPane);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 76, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(findRadioButton)
                .addGap(29, 29, 29)
                .addComponent(matchRadioButton)
                .addGap(281, 281, 281)
                .addComponent(evalButton))
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel2)
                .addContainerGap())
            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 495, Short.MAX_VALUE)
            .addComponent(jScrollPane1)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel3)
                .addContainerGap())
            .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 495, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addGap(5, 5, 5)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 169, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 177, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(15, 15, 15)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(evalButton)
                    .addComponent(matchRadioButton)
                    .addComponent(findRadioButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 152, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * The main action method of the application.
     * @param evt The event that was fired.
     */
    private void evalButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_evalButtonMouseClicked
        Pattern p = Pattern.compile(regExpEditorPane.getText());
        Matcher m = p.matcher(searchTextEditorPane.getText());
        StringBuffer result = new StringBuffer();
        if (findRadioButton.isSelected()) {
            while (m.find()) {
                result.append(
                        searchTextEditorPane.getText().substring(m.start(), m.end())
                        + "\n--------------------------------------------\n");
            }
        } else if (matchRadioButton.isSelected()) {
            result.append(m.matches());
        }
        resultEditorPane.setText(result.toString());
    }//GEN-LAST:event_evalButtonMouseClicked
    
    /**
     * Run the application from the command line.
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new RegExpTestGUI().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton evalButton;
    private javax.swing.JRadioButton findRadioButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JRadioButton matchRadioButton;
    private javax.swing.ButtonGroup modeButtonGroup;
    private javax.swing.JEditorPane regExpEditorPane;
    private javax.swing.JEditorPane resultEditorPane;
    private javax.swing.JEditorPane searchTextEditorPane;
    // End of variables declaration//GEN-END:variables
    
}
